--> Pralable :
/*
USE DB_LOCK;
GO
*/

ALTER PROCEDURE dbo.P_NOUVELLE_CLEF
   @TABLE_SCHEMA sysname = 'dbo',
   @TABLE_NAME sysname,
   @CLEF VARCHAR(32),
   @ROWS INT = 1,
   @VALEUR INT OUTPUT

AS

SET NOCOUNT ON;

SET TRANSACTION ISOLATION LEVEL REPEATABLE READ;

BEGIN TRANSACTION;

BEGIN TRY

   UPDATE dbo.T_COMPTEUR_CPT
   SET    CPT_VALEUR = CPT_VALEUR + COALESCE(@ROWS, 1)
   WHERE  CPT_TABLE_SCHEMA = COALESCE(@TABLE_SCHEMA, 'dbo')
     AND  CPT_TABLE_NAME = @TABLE_NAME
     AND  CPT_CLEF = @CLEF;

   WAITFOR DELAY '00:00:10';

   SELECT @VALEUR = CPT_VALEUR - COALESCE(@ROWS, 1) + 1
   FROM   dbo.T_COMPTEUR_CPT
   WHERE  CPT_TABLE_SCHEMA = COALESCE(@TABLE_SCHEMA, 'dbo')
     AND  CPT_TABLE_NAME = @TABLE_NAME
     AND  CPT_CLEF = @CLEF;

   COMMIT;

END TRY
BEGIN CATCH

   DECLARE @MSG NVARCHAR(1024);

   IF XACT_STATE() <> 0
      ROLLBACK;

   SET @MSG = 'Transaction annule suite  erreur : ' + ERROR_MESSAGE();

   THROW 55555, @MSG, 1;

END CATCH
GO